package w83b.w83bOperacionesInternas.w83bMantenimientos.w83bConvenios;

import org.apache.commons.lang.StringUtils;

import w83b.w83bBeans.W83bConveniosBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInterna;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaConfigBean;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaErrors;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;
// TODO: Auto-generated Javadoc

/**
 * The Class W83bMovimientoConveniosOIAction.
 * 
 * @author a
 */
public class W83bMovimientoConveniosOIAction extends Q70OperacionInterna{
	
	/**
	 * preProcessMappingEntrada.
	 * 
	 * @param contexto a
	 * @param configBean a
	 * @param errors a
	 * @throws Exception e
	 */				
	protected void preProcessMappingEntrada(Q70ContextoEJIE contexto, Q70OperacionInternaConfigBean configBean, Q70OperacionInternaErrors errors) throws Exception{				
		
		
		W83bConveniosBean conveniosBean = (W83bConveniosBean)contexto.get("w83bConveniosNuevoBean");//NOPMD
		conveniosBean.setModo((String)contexto.get("modoPantalla"));
		if(StringUtils.isEmpty(conveniosBean.getConvPorEscrut())){
			conveniosBean.setConvPorEscrut(W83bClsConstantes.CONSTANTE_NO);
		}
		if(StringUtils.isEmpty(conveniosBean.getEspEnAlava())){
			conveniosBean.setEspEnAlava(W83bClsConstantes.CONSTANTE_NO);
		}
		if(StringUtils.isEmpty(conveniosBean.getEspEnBizkaia())){
			conveniosBean.setEspEnBizkaia(W83bClsConstantes.CONSTANTE_NO);
		}
		if(StringUtils.isEmpty(conveniosBean.getEspEnGuip())){
			conveniosBean.setEspEnGuip(W83bClsConstantes.CONSTANTE_NO);
		}
		//20150511 se establece el idioma en el bean
		conveniosBean.setIdioma((String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA));
		contexto.set("w83bConveniosNuevoBean",conveniosBean);
				
		super.preProcessMappingEntrada(contexto, configBean, errors);
			
	}
	
	/**
	 * postProcessMappingSalida.
	 * 
	 * @param contexto a
	 * @param errors a
	 * @throws Exception e
	 */
	protected void postProcessMappingSalida(Q70ContextoEJIE contexto, Q70OperacionInternaErrors errors) throws Exception {

		
		String resultado = (String)contexto.get("w83bResultado");
		
		if("-1".equals(resultado)){
			W83bUtilidadesComunes.anyadirMensajeErrorAplicacion(errors, "error.mensaje.baseDatosLlena", (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA));
		}else if("-2".equals(resultado)){
			W83bUtilidadesComunes.anyadirMensajeErrorAplicacion(errors, "error.mensaje.codYaExiste", (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA));
		}else{
			contexto.set(W83bClsConstantes.CONSTANTE_MENSAJES_APLICACION_NO_ERROR, "comun.mensaje.bdActualizadaOk");

			contexto.set("modoPantalla",W83bClsConstantes.MODO_EDICION);
			contexto.set("strTitleKey","comun.convenios.editarConvenio");	
			W83bConveniosBean conveniosBean = (W83bConveniosBean)contexto.get("w83bConveniosNuevoBean");
//			20150511 si no hay fecha de baja no se indica que haya baja del convenio
			if (conveniosBean.getBaja()==null || conveniosBean.getBaja().equals("")){
				if (conveniosBean.getFechaBaja().equals(""))
					conveniosBean.setBaja(W83bClsConstantes.CONSTANTE_NO);
				else
					conveniosBean.setBaja(W83bClsConstantes.CONSTANTE_SI);
			}
		}
		
		super.postProcessMappingSalida(contexto, errors);
	}
	
}
